
' MODULE:  CMDIALOG.BAS
'
' PURPOSE: Common dialog definitions
'
' AUTHOR:  Graham Plowman
'
' DATE:    23/11/95

Option Explicit

' Printing constants and type declarations...
Global Const PORTRAIT = 1
Global Const LANDSCAPE = 2
Global Const GETSETPAPERORIENT = 30

'Common Dialog Control
'Action Property
Global Const DLG_FILE_OPEN = 1
Global Const DLG_FILE_SAVE = 2
Global Const DLG_COLOR = 3
Global Const DLG_FONT = 4
Global Const DLG_PRINT = 5
Global Const DLG_HELP = 6

'File Open/Save Dialog Flags
Global Const OFN_READONLY = &H1&
Global Const OFN_OVERWRITEPROMPT = &H2&
Global Const OFN_HIDEREADONLY = &H4&
Global Const OFN_NOCHANGEDIR = &H8&
Global Const OFN_SHOWHELP = &H10&
Global Const OFN_NOVALIDATE = &H100&
Global Const OFN_ALLOWMULTISELECT = &H200&
Global Const OFN_EXTENSIONDIFFERENT = &H400&
Global Const OFN_PATHMUSTEXIST = &H800&
Global Const OFN_FILEMUSTEXIST = &H1000&
Global Const OFN_CREATEPROMPT = &H2000&
Global Const OFN_SHAREAWARE = &H4000&
Global Const OFN_NOREADONLYRETURN = &H8000&

'Color Dialog Flags
Global Const CC_RGBINIT = &H1&
Global Const CC_FULLOPEN = &H2&
Global Const CC_PREVENTFULLOPEN = &H4&
Global Const CC_SHOWHELP = &H8&

'Fonts Dialog Flags
Global Const CF_SCREENFONTS = &H1&
Global Const CF_PRINTERFONTS = &H2&
Global Const CF_BOTH = &H3&
Global Const CF_SHOWHELP = &H4&
Global Const CF_INITTOLOGFONTSTRUCT = &H40&
Global Const CF_USESTYLE = &H80&
Global Const CF_EFFECTS = &H100&
Global Const CF_APPLY = &H200&
Global Const CF_ANSIONLY = &H400&
Global Const CF_NOVECTORFONTS = &H800&
Global Const CF_NOSIMULATIONS = &H1000&
Global Const CF_LIMITSIZE = &H2000&
Global Const CF_FIXEDPITCHONLY = &H4000&
Global Const CF_WYSIWYG = &H8000&         'must also have CF_SCREENFONTS & CF_PRINTERFONTS
Global Const CF_FORCEFONTEXIST = &H10000
Global Const CF_SCALABLEONLY = &H20000
Global Const CF_TTONLY = &H40000
Global Const CF_NOFACESEL = &H80000
Global Const CF_NOSTYLESEL = &H100000
Global Const CF_NOSIZESEL = &H200000

'Printer Dialog Flags
Global Const PD_ALLPAGES = &H0&
Global Const PD_SELECTION = &H1&
Global Const PD_PAGENUMS = &H2&
Global Const PD_NOSELECTION = &H4&
Global Const PD_NOPAGENUMS = &H8&
Global Const PD_COLLATE = &H10&
Global Const PD_PRINTTOFILE = &H20&
Global Const PD_PRINTSETUP = &H40&
Global Const PD_NOWARNING = &H80&
Global Const PD_RETURNDC = &H100&
Global Const PD_RETURNIC = &H200&
Global Const PD_RETURNDEFAULT = &H400&
Global Const PD_SHOWHELP = &H800&
Global Const PD_USEDEVMODECOPIES = &H40000
Global Const PD_DISABLEPRINTTOFILE = &H80000
Global Const PD_HIDEPRINTTOFILE = &H100000

'Error Constants
Global Const CDERR_DIALOGFAILURE = -32768

Global Const CDERR_GENERALCODES = &H7FFF
Global Const CDERR_STRUCTSIZE = &H7FFE
Global Const CDERR_INITIALIZATION = &H7FFD
Global Const CDERR_NOTEMPLATE = &H7FFC
Global Const CDERR_NOHINSTANCE = &H7FFB
Global Const CDERR_LOADSTRFAILURE = &H7FFA
Global Const CDERR_FINDRESFAILURE = &H7FF9
Global Const CDERR_LOADRESFAILURE = &H7FF8
Global Const CDERR_LOCKRESFAILURE = &H7FF7
Global Const CDERR_MEMALLOCFAILURE = &H7FF6
Global Const CDERR_MEMLOCKFAILURE = &H7FF5
Global Const CDERR_NOHOOK = &H7FF4

'Added for CMDIALOG.VBX
Global Const CDERR_CANCEL = &H7FF3
Global Const CDERR_NODLL = &H7FF2
Global Const CDERR_ERRPROC = &H7FF1
Global Const CDERR_ALLOC = &H7FF0
Global Const CDERR_HELP = &H7FEF

Global Const PDERR_PRINTERCODES = &H6FFF
Global Const PDERR_SETUPFAILURE = &H6FFE
Global Const PDERR_PARSEFAILURE = &H6FFD
Global Const PDERR_RETDEFFAILURE = &H6FFC
Global Const PDERR_LOADDRVFAILURE = &H6FFB
Global Const PDERR_GETDEVMODEFAIL = &H6FFA
Global Const PDERR_INITFAILURE = &H6FF9
Global Const PDERR_NODEVICES = &H6FF8
Global Const PDERR_NODEFAULTPRN = &H6FF7
Global Const PDERR_DNDMMISMATCH = &H6FF6
Global Const PDERR_CREATEICFAILURE = &H6FF5
Global Const PDERR_PRINTERNOTFOUND = &H6FF4

Global Const CFERR_CHOOSEFONTCODES = &H5FFF
Global Const CFERR_NOFONTS = &H5FFE

Global Const FNERR_FILENAMECODES = &H4FFF
Global Const FNERR_SUBCLASSFAILURE = &H4FFE
Global Const FNERR_INVALIDFILENAME = &H4FFD
Global Const FNERR_BUFFERTOOSMALL = &H4FFC

Global Const FRERR_FINDREPLACECODES = &H3FFF
Global Const CCERR_CHOOSECOLORCODES = &H2FFF

Function SelectFile (rdlgCommon As Control, riAction As Integer, rsCaption As String, rsDefExt As String, rsFilter As String, rsQualName As String, rsFileName As String) As Integer

    ' FUNCTION:   SelectFile()
    '
    ' PURPOSE:    Uses the common file dialog to select a file for
    '             opening or for saving as
    '
    ' PARAMETERS: Control       Pointer to the common dialog control
    '             Integer       The action: DLG_FILE_OPEN or DLG_FILE_SAVE
    '             String        The dialog caption
    '             String        The default file extension eg "txt"
    '             String        The file filter string eg "Text Files (*.txt)|*.txt|All files (*.*)|*.*||"
    '             String        String to hold returned fully qualified name
    '             String        String to hold returned file name
    '
    ' RETURNS:    Integer       IDOK            User selected a file and pressed Ok
    '                           IDCANCEL        User pressed Cancel

    Dim liRc As Integer


    On Error Resume Next

    rdlgCommon.DialogTitle = rsCaption
    rdlgCommon.DefaultExt = rsDefExt
    rdlgCommon.Filter = rsFilter
    rdlgCommon.CancelError = True
    rdlgCommon.Filename = rsFileName

    If riAction = DLG_FILE_OPEN Then
	' File open

	rdlgCommon.Flags = OFN_PATHMUSTEXIST + OFN_FILEMUSTEXIST + OFN_HIDEREADONLY + OFN_NOREADONLYRETURN
    Else
	' File save as (DLG_FILE_SAVE)

	rdlgCommon.Flags = OFN_OVERWRITEPROMPT + OFN_HIDEREADONLY + OFN_PATHMUSTEXIST + OFN_NOREADONLYRETURN
    End If

    rdlgCommon.Action = riAction

    If Err = CDERR_CANCEL Then
	' User press the Cancel key

	liRc = IDCANCEL

    Else
	' User pressed the Ok key

	rsQualName = rdlgCommon.Filename
	rsFileName = rdlgCommon.FileTitle

	liRc = IDOK
    End If

    On Error GoTo 0

    SelectFile = liRc

End Function

Function SelectPrinter (rdlgCommon As Control, rsCaption As String) As Integer

    ' FUNCTION:   SelectPrinter()
    '
    ' PURPOSE:
    '
    ' PARAMETERS: Control       Pointer to the common dialog control
    '             String        The dialog caption
    '
    ' RETURNS:    Integer       IDOK            User pressed Ok
    '                           IDCANCEL        User pressed Cancel

    Dim liRc As Integer


    liRc = IDOK

    On Error Resume Next

    rdlgCommon.DialogTitle = rsCaption
    rdlgCommon.CancelError = True
    rdlgCommon.MaxFileSize = 2048
    rdlgCommon.PrinterDefault = True
    
    rdlgCommon.Flags = PD_PRINTSETUP  ' Go straight to the SETUP screen

    rdlgCommon.Action = DLG_PRINT

    If Err = CDERR_CANCEL Then
	liRc = IDCANCEL
    End If

    On Error GoTo 0

    SelectPrinter = liRc

End Function

